# Path Gradients after Flow Matching – Supplementary Material

This repository contains code and instructions to reproduce experiments from the paper **Path Gradients after Flow Matching**. The experiments focus on molecular modeling using equivariant flow matching methods.

## Datasets and Model Checkpoints

Datasets and pretrained model checkpoints are available at:

https://osf.io/srqg7/?view_only=28deeba0845546fb96d1b2f355db0da5

To run the code, place the datasets inside the `data/` directory.

## Setup

Install required dependencies (from equivariant Flow Matching):

```bash
pip install -r requirements.txt
````


Additionally, make sure the following libraries are installed:

* bgflow: [https://github.com/noegroup/bgflow](https://github.com/noegroup/bgflow)
* bgmol: [https://github.com/noegroup/bgmol/tree/main](https://github.com/noegroup/bgmol/tree/main)

I installed the actual via a apptainer on our cluster, this might be more helpful.
Information can be found here 
```bash
eqfm_conda.def
``` 

## Running Experiments

### Training

To reproduce training on the Lennard-Jones (LJ13) system:

```bash
python -m finetune_LJ \
  --n_epochs 2 \
  --n_knots_hutch 15 \
  --training_kind path \
  --lr 1E-4 \
  --n_batch 64 \
  --n_particles 13 \
  --n_holdout 500000 \
  --chkpt_path <Path-To-Checkpoint>
```

To reproduce training on the AD2 system:

```bash
python -m finetune_AD2 \
  --n_epochs 1000 \
  --n_knots_hutch 0 \
  --training_kind fm \
  --lr 5E-4 \
  --n_batch 256 \
  --use_xtb False \
  --grad_clipping True \
  --reweight_data False \
  --transferable False
```

## Evaluation

Evaluation for AD2 can be run using:

```bash
python eval_AD2.py \
  --path <Path-To-Checkpoint> \
  --n_sample_batches 134 \
  --batch-size 1500 \
  --xtb False \
  --transferable False
```

Evaluation for LJ13 can be run using:

```bash
python eval_LJ.py \
  --path <Path-To-Checkpoint> \
  --n_holdout 9500000 \
  --n_particles 13 \
  --n_sample_batches 200 \
  --batch-size 2500
```

## Notebooks

The following Jupyter notebook is included:

* `GMM_experiment.ipynb`: Demonstrates the method on a simple GMM example.


